function read_data(epsilon,indexmax,datamax,factor,LF,L,Index_Code,N)

%% With this script, we open the different files for the same experiment and
%% average all trajectories, computing the mean evolution and the variance
%% around such path.

%% tau: see trayec.m

%% indexmax is the maximum number of files for the same simulation

%% datamax: number of trajectories per file

%% factor: see trayec.m

%% type: see trayect.m

%% Pablo M. Olmos, 2013. olmos@tsc.uc3m.es

[Hfile,~,CodName] = cod_string(Index_Code,LF,L,1,1);

%Mat=F=zeros(2,datamax*indexmax);
MatF=[];
countdata=0;
flag=0;

for index=1:1:indexmax
    
    filedir=(['./Data_Random/Data_' CodName '_eps_' num2str(round(epsilon*10000)) '_index_' num2str(index) '.mat']);
        
    fid=fopen(filedir,'r');
    
    if(fid>-1)
        flag=1;
        fclose(fid);
        load(filedir,'NData','F');

        MatF=[MatF F];
        
        countdata=countdata+1;
    end;     
end;






if(flag==1)
    
    disp('Computing mean and variance evolution');

    savefile=(['./Processed_Data/' CodName '_eps_' num2str(round(epsilon*10000)) '.mat']); 
        
    save(savefile,'LF','L','epsilon','factor','countdata','MatF','N');
else
    disp('No simulated data for the indicated parameters');
end;




